// Exp-7 Perform Circular Shifting Operation on Discrete Sequence and prove

// Version : Scilab 5.4.1
// Operating Syatem : Window-xp, Window-7

clc;
clear;
xdel(winsid());

n=0:10;  // Index
x=10*(0.8).^n;  // Input Sequence
y=x(pmodulo(-n,length(n))+1);   // y is circular shifted sequence of x 

scf();
subplot(2,1,1);
bar(x,0.1,'Green');
title('Original Sequence','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");

subplot(2,1,2);
bar(y,0.1,'yellow');
title('Circular Shifted Sequence','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");


X=fft(x,-1); // Discrete Fourier Transform of Original Sequence
Y= fft(y,-1); // Discrete Fourier Transform of Circular Shifted Sequence

scf(); 
subplot(2,2,1);
bar(n,real(X),0.1,'Green');
title('Real{DFT[x(n)]}','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");


subplot(2,2,2);
bar(n,imag(X),0.1,'Green');
title('Imag{DFT[x(n)]}','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");

subplot(2,2,3);
bar(n,real(Y),0.1,'Green');
title('Real{DFT[x((-n))]}','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");

subplot(2,2,4);
bar(n,imag(Y),0.1,'Green');
title('Imag{DFT[x((-n))]}','color','red','fontsize', 4);
xlabel("Index", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");


